# Generated by Django 5.2.4 on 2025-12-17 10:26

import django.utils.timezone
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=191)),
                ('site', models.CharField(max_length=50)),
                ('price', models.DecimalField(decimal_places=2, max_digits=12)),
                ('url', models.URLField(max_length=255, unique=True)),
                ('image_url', models.URLField(blank=True, max_length=500, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True)),
                ('stock', models.BooleanField(default=True)),
                ('return_policy', models.TextField(blank=True, null=True)),
                ('last_checked', models.DateTimeField(default=django.utils.timezone.now)),
            ],
        ),
        migrations.CreateModel(
            name='ProductClick',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('product_name', models.CharField(max_length=255)),
                ('site', models.CharField(max_length=255)),
                ('country', models.CharField(blank=True, max_length=100, null=True)),
                ('device', models.CharField(blank=True, max_length=255, null=True)),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'permissions': [('view_analytics', 'Can view analytics')],
            },
        ),
        migrations.CreateModel(
            name='ActiveScraper',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('query', models.CharField(db_index=True, max_length=255)),
                ('site', models.CharField(max_length=50)),
                ('job_id', models.CharField(editable=False, max_length=100, unique=True)),
                ('start_time', models.DateTimeField(default=django.utils.timezone.now)),
                ('end_time', models.DateTimeField(blank=True, null=True)),
                ('status', models.CharField(choices=[('RUNNING', 'Running'), ('SUCCESS', 'Success'), ('FAILED', 'Failed'), ('EXPIRED', 'Expired/Stale')], default='RUNNING', max_length=20)),
            ],
            options={
                'verbose_name': 'Active Scraper Job',
                'verbose_name_plural': 'Active Scraper Jobs',
                'unique_together': {('query', 'site')},
            },
        ),
    ]
