"""
Django settings for api project.

Generated by 'django-admin startproject' using Django 5.2.4.

For more information on this file, see
https://docs.djangoproject.com/en/5.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/5.2/ref/settings/
"""

from pathlib import Path
import os
from datetime import timedelta

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'django-insecure-t(nosa0g97nu!z2k9&t^4%s9(#$k1#(8wu_k*erzkcq5tz3sle'
# SECRET_KEY = os.getenv("DJANGO_SECRET_KEY", "insecure")




# SECURITY WARNING: don't run with debug turned on in production!
# DEBUG = True
# DEBUG = os.getenv("DJANGO_DEBUG", "False") == "True"

ALLOWED_HOSTS = []
# ALLOWED_HOSTS = os.getenv("DJANGO_ALLOWED_HOSTS", "").split(",")

DEBUG = False

ALLOWED_HOSTS = [
    "api.prizehubs.org",
    "prizehubs.org"
]



# Application definition

INSTALLED_APPS = [
    'corsheaders',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',

    'rest_framework',
    'rest_framework.authtoken',
    'channels',
    'products',
    'accounts',
    'django_celery_results',
    'django_celery_beat',
    
]

AUTH_USER_MODEL = 'accounts.User'


MIDDLEWARE = [
    'corsheaders.middleware.CorsMiddleware',
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'api.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'api.wsgi.application'


# Database
# https://docs.djangoproject.com/en/5.2/ref/settings/#databases

# DATABASES = {
#     'default': {
#         'ENGINE': 'django.db.backends.sqlite3',
#         'NAME': BASE_DIR / 'db.sqlite3',
#     }
# }

# DATABASES = {
#     'default': {
#         'ENGINE': 'django.db.backends.postgresql',
#         'NAME': 'aggregator_db',
#         'USER': 'postgres',
#         'PASSWORD': 'postgres',
#         #'HOST': 'db',
#         'HOST': 'localhost'
#         'PORT': '5432',
#     }
# }

DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.mysql",
        "NAME": os.getenv("MYSQL_DATABASE", "prizehubs"),
        "USER": os.getenv("MYSQL_USER", "prizehubs_user"),
        "PASSWORD": os.getenv("MYSQL_PASSWORD", "Egwuaka1987"),
        "HOST": os.getenv("DB_HOST", "127.0.0.1"),
        "PORT": os.getenv("DB_PORT", "3306"),
        "OPTIONS": {"charset": "utf8mb4"},
    }
}


# Password validation
# https://docs.djangoproject.com/en/5.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/5.2/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/5.2/howto/static-files/


STATIC_URL = "/static/"
# STATIC_ROOT = "/static"
MEDIA_URL = "/media/"
MEDIA_ROOT = "/media"

STATIC_ROOT = BASE_DIR / 'staticfiles'

# Default primary key field type
# https://docs.djangoproject.com/en/5.2/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'


# Celery configuration
# CELERY_BROKER_URL = "redis://localhost:6380/0"
# CELERY_BROKER_URL = "redis://redis:6379/0"
CELERY_BROKER_URL = 'redis://localhost:6379/0'
# CELERY_BROKER_URL = 'redis://redis:6379/0'
# CELERY_BROKER_URL = 'amqp://guest:guest@localhost:5672//'

CELERY_TASK_MAX_PRIORITY = 10 
CELERY_TASK_DEFAULT_PRIORITY = 5 
CELERY_BROKER_TRANSPORT_OPTIONS = {
    'priority_steps': list(range(11)),
    'queue_order_strategy': 'priority',
    'visibility_timeout': 900,  
}


CELERY_TASK_QUEUES = {
    # Fast queue for Jumia (and potentially other quick tasks)
    'fast_queue': {
        'exchange': 'fast_queue',
        'exchange_type': 'direct',
        'binding_key': 'fast_queue',
    },
    # Default queue for long-running/normal tasks
    'default': {
        'exchange': 'default',
        'exchange_type': 'direct',
        'binding_key': 'default',
    },
}

# Map the tasks to their respective queues
CELERY_TASK_ROUTES = {
    'products.tasks.scrape_jumia_task': {'queue': 'fast_queue'},
    'products.tasks.scrape_slot_task': {'queue': 'default'},
    'products.tasks.scrape_konga_task': {'queue': 'default'},
    
}

CELERY_RESULT_BACKEND = 'django-db'
CELERY_ACCEPT_CONTENT = ['json']
CELERY_TASK_SERIALIZER = 'json'


CORS_ALLOW_ALL_ORIGINS = True  
# CORS_ALLOWED_ORIGINS = os.getenv("CORS_ALLOWED_ORIGINS", "").split(",") if os.getenv("CORS_ALLOWED_ORIGINS") else []
# CSRF_TRUSTED_ORIGINS = os.getenv("CSRF_TRUSTED_ORIGINS", "").split(",") if os.getenv("CSRF_TRUSTED_ORIGINS") else []

# docker compose -f docker-compose.dev.yml up -d
# docker compose -f docker-compose.dev.yml down -v
# docker compose -f docker-compose.dev.yml up -d --build


ASGI_APPLICATION = 'api.asgi.application' 

# 2. Channel Layer Configuration

CHANNEL_LAYERS = {
    "default": {
        "BACKEND": "channels_redis.core.RedisChannelLayer",  
        "CONFIG": {
            "hosts": [("127.0.0.1", 6379)],
        },
    },
}

REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': [
        'rest_framework.authentication.TokenAuthentication',
    ],
    'DEFAULT_PERMISSION_CLASSES': [
        'rest_framework.permissions.IsAuthenticated',
    ],
}