import os
from celery import Celery

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "api.settings")

app = Celery("api")
app.config_from_object("django.conf:settings", namespace="CELERY")
app.conf.broker_url = os.getenv("CELERY_BROKER_URL", "redis://redis:6379/1")
app.conf.result_backend = os.getenv("CELERY_RESULT_BACKEND", "redis://redis:6379/2")
app.autodiscover_tasks()

