"""
ASGI config for api project.

It exposes the ASGI callable as a module-level variable named ``application``.

For more information on this file, see
https://docs.djangoproject.com/en/5.2/howto/deployment/asgi/
"""

# api/asgi.py (Replace 'api' with your project name)
import os
from channels.auth import AuthMiddlewareStack
from channels.routing import ProtocolTypeRouter, URLRouter
from django.core.asgi import get_asgi_application
import products.routing # Import the routing file we are about to create


os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'api.settings')

application = ProtocolTypeRouter({
    "http": get_asgi_application(), # Standard Django HTTP requests
    "websocket": AuthMiddlewareStack( # WebSocket connections, wrapped in auth middleware (optional but recommended)
        URLRouter(
            products.routing.websocket_urlpatterns
        )
    ),
})