from ..models import ActivityLog

# def log_activity(
#     user=None,
#     action="",
#     description="",
#     request=None
# ):
#     ip = None
#     agent = ""

#     if request:
#         ip = request.META.get("REMOTE_ADDR")
#         agent = request.META.get("HTTP_USER_AGENT", "")

#     ActivityLog.objects.create(
#         user=user,
#         action=action,
#         description=description,
#         ip_address=ip,
#         user_agent=agent
#     )

def log_activity(
    user=None,
    action="",
    description="",
    request=None
):
    ip = None
    agent = ""

    if request:
        # Respect proxy/load balancer
        ip = request.META.get("HTTP_X_FORWARDED_FOR")
        if ip:
            ip = ip.split(",")[0]
        else:
            ip = request.META.get("REMOTE_ADDR")

        agent = request.META.get("HTTP_USER_AGENT", "")

    ActivityLog.objects.create(
        user=user if user and user.is_authenticated else None,
        action=action,
        description=description,
        ip_address=ip,
        user_agent=agent
    )

def log_search(request, keyword):

    ip = request.META.get("HTTP_X_FORWARDED_FOR")
    if ip:
        ip = ip.split(",")[0]
    else:
        ip = request.META.get("REMOTE_ADDR")

    ActivityLog.objects.create(
        user=request.user if request.user.is_authenticated else None,
        action="search",
        keyword=keyword.lower(),
        description=f"Searched for '{keyword}'",
        ip_address=ip,
        user_agent=request.META.get("HTTP_USER_AGENT", "")
    )