from django.urls import path
from .views import ActivityLogAPIView, AdminUserListAPIView, AdminUserUpdateAPIView, RegisterAPIView, LoginAPIView, LogoutAPIView, PopularSearchTrendsAPIView,ProductClickListAPIView

urlpatterns = [
    path('register/', RegisterAPIView.as_view()),
    path('login/', LoginAPIView.as_view()),
    path('logout/', LogoutAPIView.as_view()),
    path("activity-logs/", ActivityLogAPIView.as_view()),
    path("search-trends/", PopularSearchTrendsAPIView.as_view()),
    path("admin/users/", AdminUserListAPIView.as_view()),
    path("admin/users/<int:user_id>/", AdminUserUpdateAPIView.as_view()),
    path('product-clicks/list/', ProductClickListAPIView.as_view(), name='product-clicks-list'),
]
