from rest_framework import serializers
from django.contrib.auth import authenticate, get_user_model

from .models import ActivityLog

User = get_user_model()



class RegisterSerializer(serializers.ModelSerializer):
    password = serializers.CharField(write_only=True)
    password2 = serializers.CharField(write_only=True)

    class Meta:
        model = User
        fields = (
            'username', 'email', 'password', 'password2',
            'role', 'phone', 'company', 'country'
        )

    def validate(self, data):
        if data['password'] != data['password2']:
            raise serializers.ValidationError("Passwords do not match")
        return data

    def create(self, validated_data):
        validated_data.pop('password2')
        return User.objects.create_user(**validated_data)


class LoginSerializer(serializers.Serializer):
    username = serializers.CharField()
    password = serializers.CharField()

    def validate(self, data):
        user = authenticate(**data)
        if not user:
            raise serializers.ValidationError("Invalid credentials")
        data['user'] = user
        return data



# class ActivityLogSerializer(serializers.ModelSerializer):
#     username = serializers.CharField(source="user.username", read_only=True)

#     class Meta:
#         model = ActivityLog
#         fields = "__all__"

# from rest_framework import serializers
# from .models import ActivityLog

class ActivityLogSerializer(serializers.ModelSerializer):
    user = serializers.CharField(source="user.username", default="Unknown", read_only=True)

    class Meta:
        model = ActivityLog
        fields = [
            "id",
            "user",
            "action",
            "keyword",
            "description",
            "ip_address",
            "user_agent",
            "created_at",
        ]


class AdminUserSerializer(serializers.ModelSerializer):
    class Meta:
        model = User
        fields = [
            "id",
            "username",
            "email",
            "role",
            "is_active",
            "phone",
            "company",
            "country",
            "date_joined"
        ]
