from rest_framework.permissions import BasePermission


class IsAnalyst(BasePermission):
    """
    Allows access only to analyst users
    """

    def has_permission(self, request, view):
        return (
            request.user
            and request.user.is_authenticated
            and request.user.role == 'analyst'
        )
