from rest_framework.permissions import BasePermission

class IsAdminOrAnalyst(BasePermission):
    """
    Allows access only to users with role 'admin' or 'analyst'
    """

    def has_permission(self, request, view):
        return (
            request.user
            and request.user.is_authenticated
            and request.user.role in ['admin', 'analyst']
        )
